SOURCES += \
    $$files(src/main.cpp) \
    $$files(src/hrbf/*.cpp) \
    $$files(src/hrbf/hrbf_core/*.cpp) \
    $$files(src/meshes/*.cpp) \
    $$files(src/parsers/*.cpp) \
    $$files(src/qt_gui/*.cpp) \
    $$files(src/qt_gui/common/*.cpp) \
    $$files(src/qt_gui/common/gizmo/*.cpp) \
    $$files(src/qt_gui/common/popup/*.cpp) \
    $$files(src/qt_gui/common/toolbars/*.cpp) \
    $$files(src/qt_gui/common/tools/*.cpp) \
    $$files(src/rendering/*.cpp) \
    $$files(src/rendering/marching_cubes/*.cpp) \
    $$files(src/scene_tree/*.cpp) \
    $$files(src/scene_tree/implicit_surfaces/*.cpp) \
    $$files(src/utils/*.cpp) \
    $$files(src/utils/gl_utils/*.cpp) \
    $$files(src/utils/maths/*.cpp) \
    $$files(src/utils/maths/intersections/*.cpp) \
    $$files(src/global_datas/*.cpp)

HEADERS += \
    $$files(src/*.hpp) \
    $$files(src/hrbf/*.hpp) \
    $$files(src/hrbf/hrbf_core/*.hpp) \
    $$files(src/utils/maths/*.hpp) \
    $$files(src/utils/maths/intersections/*.hpp) \
    $$files(src/meshes/*.hpp) \
    $$files(src/parsers/*.hpp) \
    $$files(src/qt_gui/*.hpp) \
    $$files(src/qt_gui/common/*.hpp) \
    $$files(src/qt_gui/common/gizmo/*.hpp) \
    $$files(src/qt_gui/common/popup/*.hpp) \
    $$files(src/qt_gui/common/toolbars/*.hpp) \
    $$files(src/qt_gui/common/tools/*.hpp) \
    $$files(src/qt_gui/common/widgets/*.hpp) \
    $$files(src/rendering/*.hpp) \
    $$files(src/rendering/marching_cubes/*.hpp) \
    $$files(src/scene_tree/*.hpp) \
    $$files(src/scene_tree/implicit_surfaces/*.hpp) \
    $$files(src/utils/*.hpp) \
    $$files(src/utils/gl_utils/*.hpp) \
    $$files(src/utils/portable_includes/*.hpp) \
    $$files(src/utils/cuda_utils/*.hpp) \
    $$files(src/utils/containers/*.hpp) \
    $$files(src/global_datas/*.hpp)

INCLUDEPATH += \
    ../libs/include/Eigen \
    ../libs/include/Eigen_unsupported \
    ../libs/include/ \
    src/ \
    src/hrbf \
    src/hrbf/hrbf_core \
    src/hrbf/mcubes \
    src/utils/maths/ \
    src/utils/maths/intersections/ \
    src/utils/containers/ \
    src/meshes/ \
    src/parsers/ \
    src/qt_gui/ \
    src/rendering/ \
    src/rendering/marching_cubes \
    src/scene_tree/ \
    src/scene_tree/implicit_surfaces/ \
    src/utils/ \
    src/utils/portable_includes/ \
    src/utils/gl_utils/ \
    src/utils/cuda_utils/ \
    src/global_datas

# Otherwise make doesn't detect headers changes and don't recompile!
# This might be related to the $$files command I never had to use DEPENDPATH
# before so there must be a way to avoid this ugliness.
DEPENDPATH += $${INCLUDEPATH}

LIBS += -lglut -lGL -lGLU -lGLEW

QT += opengl

FORMS += \
    $$files(src/qt_gui/common/*.ui) \
    $$files(src/qt_gui/common/popup/*.ui) \
    $$files(src/qt_gui/common/widgets/*.ui) \
    $$files(src/qt_gui/common/toolbars/*.ui) \
    $$files(src/qt_gui/*.ui)

# Means we should not have to install the CUDA SDK and headers
DEFINES += "NCUDA"

# As fast as possible XD
QMAKE_CXXFLAGS_RELEASE -= -O2
QMAKE_CXXFLAGS_RELEASE += -O3
