/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef G_SHADERS_HPP__
#define G_SHADERS_HPP__

#include "shader.hpp"

/** @file g_shaders.hpp
    @brief export the global variables variables related to shader programs
    @see globals.cpp
*/

/// Various shader programs
extern Shader_prog* g_dummy_quad_shader;
extern Shader_prog* g_normal_map_shader;
extern Shader_prog* g_ssao_shader;

/// 'phong_list' is a list of shaders generated from a single file source
/// the enum field specifies which type of shader is in the list
enum {
    NO_TEX,            ///< phong shading no texture
    MAP_KD,            ///< phong shading only diffuse texture
    MAP_KD_BUMP,       ///< phong shading only bump and diffuse textures
    MAP_KD_KS,         ///< phong shading only diffuse and specular textures
    NB_PHONG_SHADERS
};

/// @namespace Tex_units
/// @brief specifies which textures units are used in 'phong_list'
namespace Tex_units{
    extern const int KD;
    extern const int KS;
    extern const int BUMP;
}

extern Shader_prog* g_phong_list[NB_PHONG_SHADERS];

#endif // G_SHADERS_HPP__
