/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef G_VBO_PRIMITIVES_HPP__
#define G_VBO_PRIMITIVES_HPP__

/** @file g_vbo_primitives.hpp
    @brief export global variables related to vbos primitives
    @see globals.cpp
*/

#include "vbo_primitives.hpp"

/// Some basic primitive are available, they are upload into the GPU
/// at the initialization of opengl
/// @see init_opengl()
/// @note 'lr' stands for low res
extern VBO_primitives g_primitive_printer;
extern Prim_id g_sphere_lr_vbo;
extern Prim_id g_sphere_vbo;
extern Prim_id g_circle_vbo;
extern Prim_id g_arc_circle_vbo;
extern Prim_id g_circle_lr_vbo;
extern Prim_id g_arc_circle_lr_vbo;
extern Prim_id g_grid_vbo;
extern Prim_id g_cylinder_vbo;
extern Prim_id g_cylinder_cage_vbo;
extern Prim_id g_cube_vbo;

#endif // G_VBO_PRIMITIVES_HPP__
