/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "globals.hpp"
#include "g_shaders.hpp"

#include "vbo_primitives.hpp"
#include "g_scene_tree.hpp"


// -----------------------------------------------------------------------------

void init_global_datas()
{
    g_scene_tree = new Scene_tree();
}

// -----------------------------------------------------------------------------

void init_gl_global_datas()
{

}

// -----------------------------------------------------------------------------

void clean_global_data()
{
    delete g_scene_tree;
}

// -----------------------------------------------------------------------------

Loader::Point_cache_file* g_anim_cache = 0;

// -----------------------------------------------------------------------------

Scene_tree* g_scene_tree = 0;

// -----------------------------------------------------------------------------

VBO_primitives g_primitive_printer;
Prim_id g_sphere_lr_vbo;
Prim_id g_sphere_vbo;
Prim_id g_circle_vbo;
Prim_id g_arc_circle_vbo;
Prim_id g_circle_lr_vbo;
Prim_id g_arc_circle_lr_vbo;
Prim_id g_grid_vbo;
Prim_id g_cylinder_vbo;
Prim_id g_cylinder_cage_vbo;
Prim_id g_cube_vbo;

GLuint g_gl_quad;

// -----------------------------------------------------------------------------

GLuint g_gl_Tex[NB_TEX];

// -----------------------------------------------------------------------------

Shader_prog* g_dummy_quad_shader = 0;
Shader_prog* g_normal_map_shader = 0;
Shader_prog* g_ssao_shader = 0;

namespace Tex_units{
    const int KD   = 3;
    const int KS   = 4;
    const int BUMP = 5;
}

Shader_prog* g_phong_list[NB_PHONG_SHADERS];

// -----------------------------------------------------------------------------

//std::string write_dir = "/export/home/magritte/vaillant/ppm_img";
std::string g_shaders_dir = "./shaders";
std::string g_write_dir   = "./resource";
std::string g_cache_dir   = "./resource/app_cache";
std::string g_config_dir  = "./resource/app_config";
std::string g_icons_dir   = "./resource/icons";

bool g_shooting_state = false;
bool g_save_anim = false;
GlShoot* g_oglss;

// -----------------------------------------------------------------------------

