/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef GLOBAL_HPP__
#define GLOBAL_HPP__

#include <string>
#include "port_glew.h"
#include "glshoot.hpp"
#include "point_cache_export.hpp"

/** @file globals.hpp
    @brief Various global variables
*/

// -----------------------------------------------------------------------------

void init_global_datas();

/// @warning Opengl objects needs to be initialized after the opengl context
/// is ready
void init_gl_global_datas();

void clean_global_data();

// -----------------------------------------------------------------------------

extern Loader::Point_cache_file* g_anim_cache;

// -----------------------------------------------------------------------------
/// Vbo id of the quad used to display the pbo that contains the result
/// of the raytracing done by cuda
extern GLuint g_gl_quad;
// -----------------------------------------------------------------------------

/// use these to index pbos & textures:
enum{ COLOR = 0,
      DEPTH,
      MAP,
      NORMAL_MAP, ///< scene normals
      NOISE,
      NB_TEX      // Keep that at the end
     };

/// Textures that store color and depth buffer + map
extern GLuint g_gl_Tex[NB_TEX];

// -----------------------------------------------------------------------------

extern bool g_shooting_state;
extern bool g_save_anim;
extern GlShoot* g_oglss;

// -----------------------------------------------------------------------------

#endif // GLOBAL_HPP__
