/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "loader.hpp"

#include "obj_loader.hpp"
#include "off_loader.hpp"
#include "std_utils.hpp"

static std::string get_file_path(const std::string& path)
{
    std::string res;
    unsigned pos = path.find_last_of('/');

    if( (pos+1) == path.size())
        return path;
    else
    {
        if( pos < path.size()) res = path.substr(0, pos+1);
        else                   res = "";
    }

    return res;
}

// =============================================================================
namespace Loader {
// =============================================================================

Base_loader* make_loader(const std::string& file_name)
{
    std::string ext = Std_utils::to_lower( Std_utils::file_ext(file_name) );

    /*
    if( ext == ".fbx")
        return new Loader::Fbx_file(file_name);
    else
    */
    if( ext == ".obj")
        return new Loader::Obj_file(file_name);
    else if( ext == ".off")
        return new Loader::Off_file(file_name);
    /*
    else if( ext == ".skel")
        return new Loader::Graph_file(file_name);
    */
    else
        return 0;
}

// CLASS Base_loader ===========================================================

Base_loader::Base_loader(const std::string& file_path)
{
    update_paths(file_path);
}

//------------------------------------------------------------------------------

void Base_loader::update_paths(const std::string& file_path)
{
    _file_path = file_path;
    _path      = get_file_path(file_path);
}

// =============================================================================
} // namespace Loader
// =============================================================================
