/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef TEX_LOADER_HPP__
#define TEX_LOADER_HPP__

#include "gltex2D.hpp"
#include <string>

// =============================================================================
namespace Loader {
// =============================================================================

/**
  @namespace Tex_loader
  @brief Loading/writting openGL textures utilities (using Qt4 QImage class)

*/
// =============================================================================
namespace Tex_loader{
// =============================================================================

/// @param file_path : path to the texture image. We use Qt to parse the image
/// file, so what QImage can open this function can too.
/// @return An openGL textures
GlTex2D* load(const std::string& file_path);

}// END TEX_LOADER NAMESPACE ===================================================

}// END LOADER NAMESPACE =======================================================

#endif // TEX_LOADER_HPP__
