/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef IO_DISABLE_SKIN2_HPP__
#define IO_DISABLE_SKIN2_HPP__

#include "IO_interface.hpp"

/** @brief Disables mouse and keys
  @see IO_interface
*/

class IO_disable : public IO_interface {
public:
    IO_disable(OGL_widget* gl_widget) : IO_interface(gl_widget){ }

    void mousePressEvent  (QMouseEvent* e){ e->ignore(); }
    void mouseReleaseEvent(QMouseEvent* e){ e->ignore(); }
    void mouseMoveEvent   (QMouseEvent* e){ e->ignore(); }
    void wheelEvent       (QWheelEvent* e){ e->ignore(); }
    void keyPressEvent    (QKeyEvent*   e){ e->ignore(); }
    void keyReleaseEvent  (QKeyEvent*   e){ e->ignore(); }
};

#endif // IO_DISABLE_SKIN2_HPP__
