/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef OGL_WIDGET_ENUM_HPP
#define OGL_WIDGET_ENUM_HPP

// =============================================================================
namespace EOGL_widget {
// =============================================================================

/// @name Pivot_t
/// @brief Defines the center of rotation mode
enum Pivot_t {
    JOINT = 0,     ///< rotate around a joint
    BONE = 1,      ///< rotate around the midlle of a bone
    SELECTION = 2, ///< Rotate around the cog of selected elments
    USER = 3,      ///< Rotate around a point defined by the user
    FREE = 4       ///< no center of rotation
};

/// @name Select_t
/// @brief Defines the selection mode
enum Select_t {
    MOUSE,      ///< Use mouse cursor
    CIRCLE,     ///< Use circle area
    BOX,        ///< Use box area
    FREE_FORM   ///< Use free form
};

} // END OGL_widget ============================================================

#endif // OGL_WIDGET_ENUM_HPP
