/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef GIZMO_SCALE2_HPP__
#define GIZMO_SCALE2_HPP__

#include "gizmo.hpp"
#include "port_glew.h"
#include "vec3_cu.hpp"
#include "camera.hpp"

/**
  @name Gizmo_scale
  @brief 3D frame to provide GUI for object scaling.
  This class provide methods for scaling objects in the GUI.
  It memories the current scale and compute its new scale
  given the mouse position and axis/plane constraint. It also gives means to
  draw a custom oriented frame which is represented by arrows. Each arrow can be
  selected.

  @see Gizmo
*/

// TODO: to be implemented

class Gizmo_scale : public Gizmo {
public:

   Gizmo_scale(): Gizmo() { }

    /// draw the current selected point and frame. Frame is represented with
    /// arrows (green, red and blue) made of a cylinder and a cone for the tip.
    /// Frame is drawn at the position specified by '_frame.get_translation()'.
    /// X, Y and Z arrows orientations are defined by 'set_frame()'.
    void draw(const Camera& /*cam*/)
    {

    }

    /// select the x or y or z frame axis given a camera and a mouse position
    /// updates attributes (_axis or _plane) and _constraint
    /// @return true if one of the axis is selected
    bool select_constraint(const Camera& /*cam*/, int /*px*/, int /*py*/)
    {
        // slide_from();
        return false;
    }

    /// reset the selected constraint set by select_constraint()
    void reset_constraint()
    {

    }

    /// @brief scale object given the current constraint (plane or axis)
    /// If a constraint has been selected this will scale the selected object
    /// following the constraint and keeping the frame arrow
    /// as close as possible under the mouse position (px, py)
    /// @return the scaling made by the frame in world coordinates
    /// @see select_constraint()
    TRS slide(const Camera& /*cam*/, int /*px*/, int /*py*/)
    {
        return TRS();
    }

private:

};

#endif // GIZMO_SCALE2_HPP__
