/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef GIZMO_TRACKBALL2_HPP__
#define GIZMO_TRACKBALL2_HPP__

#include "gizmo.hpp"
#include "vec3_cu.hpp"
#include "transfo.hpp"
#include "camera.hpp"
#include "glpick.hpp"

/**
  @class Gizmo_trackball
  @brief Specialization of the gizmo to handle trackballs movements

  A trackball enables the user to grab anywhere on the screen a virtual ball
  and move it according to the dragged point. usually more intuitive to achieve
  complex rotations.

  @see Gizmo
*/
class Gizmo_trackball : public Gizmo {
public:

    enum Axis_t {BALL,
                 NOAXIS
                };

    Gizmo_trackball();

    void draw(const Camera& cam);

    /// @note always returns true (except when show == false).
    /// Call is needed for the gizmo to compute the rotation
    bool select_constraint(const Camera& cam, int px, int py);

    void reset_constraint(){ _selected_axis = NOAXIS; }

    TRS slide(const Camera& cam, int px, int py);

private:
    // -------------------------------------------------------------------------
    /// @name Tools
    // -------------------------------------------------------------------------
    TRS trackball_rotation(const Camera& cam, int px, int py);

    // -------------------------------------------------------------------------
    /// @name Attributes
    // -------------------------------------------------------------------------
    float _rad_sphere;    ///< Radius of the sphere representing the trackball
    float _rad_handles;   ///< Radius of the tore reprensenting the handles
    float _ortho_factor;

    /// current selected axis
    Axis_t _selected_axis;

    /// World coordinates of the picked point
    Vec3_cu _picked_pos;
};

#endif // GIZMO_TRACKBALL2_HPP__
