/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef QT_UTILS_HPP
#define QT_UTILS_HPP

#include <QWidget>
#include <QLayout>
#include <QKeyEvent>

// ============================================================================
namespace Qt_utils {
// ============================================================================

/// Recursively hide/show every widget of a QLayout
static inline
void rec_set_visible( const QLayout &layout, bool visible )
{
    for (int i=0; i<layout.count(); ++i){
        if ( QWidget *w = layout.itemAt(i)->widget() )
            w->setVisible( visible );
        else if ( QLayout *l = layout.itemAt(i)->layout() )
            rec_set_visible( *l, visible );
    }
}

// -----------------------------------------------------------------------------

/// convert a key event to a char. Usefull to  distinguish upper/lower case
/// key characters
/// @warning returned value is undefined for multiple key strokes
static inline
char event_to_char(QKeyEvent* event)
{
    QString t = event->text();
    QChar c = t[0];
    return c.toAscii();
}

}// END NAMESPACE QT_UTILS =====================================================

#endif // QT_UTILS_HPP
