/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "common/toolbars/toolbar.hpp"
#include "common/OGL_widget_enum.hpp"
#include "IO_selection_enum.hpp"

Toolbar::Toolbar(QWidget* parent) :
    QToolBar(parent)
{
    // Adding toolButtons for selection
#if 0
    _wgt_select = new Widget_selection(this);
    this->addWidget( _wgt_select );
    this->addSeparator();
#endif

    _wgt_viewport = new Widget_viewports(this);
    this->addWidget( _wgt_viewport );
    this->addSeparator();

    // Adding toolButtons for gizmo
    _wgt_gizmo = new Widget_gizmo(this);
    this->addWidget( _wgt_gizmo );
    this->addSeparator();

    // Adding toolButtons for the rendering mode
#if 0
    _wgt_rd_mode = new Widget_render_mode(this);
    this->addWidget( _wgt_rd_mode );
    this->addSeparator();

    _wgt_fit = new Widget_fitting( this );
    this->addWidget( _wgt_fit );
    this->addSeparator();

    // Adding combo box for the camera pivot mode
    _pivot_comboBox = new QComboBox( this );
    _pivot_comboBox->setObjectName(QString::fromUtf8("pivot_comboBox"));
    _pivot_comboBox->addItem("Joint"    , (int)EOGL_widget::JOINT     );
    _pivot_comboBox->addItem("Bone"     , (int)EOGL_widget::BONE      );
    _pivot_comboBox->addItem("Selection", (int)EOGL_widget::SELECTION );
    _pivot_comboBox->addItem("User"     , (int)EOGL_widget::USER      );
    _pivot_comboBox->addItem("Free"     , (int)EOGL_widget::FREE      );
    _pivot_comboBox->setCurrentIndex(3);
    this->addWidget(_pivot_comboBox);

    // Adding combo box for the gizmo pivot mode
    _pivot_gizmo_comboBox = new QComboBox( this );
    _pivot_gizmo_comboBox->setObjectName(QString::fromUtf8("pivot_comboBox") );
    _pivot_gizmo_comboBox->addItem("Median"   , (int)EIO_Selection::MEDIAN   );
    _pivot_gizmo_comboBox->addItem("Active"   , (int)EIO_Selection::ACTIVE   );
    _pivot_gizmo_comboBox->addItem("3D cursor", (int)EIO_Selection::CURSOR_3D);
    this->addWidget(_pivot_gizmo_comboBox);
#endif

    // Adding combo box for the gizmo dir mode
    _dir_gizmo_comboBox = new QComboBox( this );
    _dir_gizmo_comboBox->setObjectName(QString::fromUtf8("pivot_comboBox"));
    _dir_gizmo_comboBox->addItem("Local" , (int)EIO_Selection::LOCAL   );
    _dir_gizmo_comboBox->addItem("Global", (int)EIO_Selection::GLOBAL  );
    _dir_gizmo_comboBox->addItem("Normal", (int)EIO_Selection::NORMAL  );
    _dir_gizmo_comboBox->addItem("View"  , (int)EIO_Selection::VIEW    );
    this->addWidget(_dir_gizmo_comboBox);
}
