/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef TOOLBAR_HPP__
#define TOOLBAR_HPP__

// -----------------------------------------------------------------------------

#include "qt_gui/common/toolbars/widget_fitting.hpp"
#include "qt_gui/common/toolbars/widget_gizmo.hpp"
#include "qt_gui/common/toolbars/widget_selection.hpp"
#include "qt_gui/common/toolbars/widget_viewports.hpp"
#include "qt_gui/common/toolbars/widget_render_mode.hpp"

// -----------------------------------------------------------------------------

#include <QToolBar>
#include <QComboBox>

// -----------------------------------------------------------------------------

class Toolbar : public QToolBar {
    Q_OBJECT
public:

    Toolbar(QWidget* parent);

    Widget_selection*   _wgt_select;
    Widget_viewports*   _wgt_viewport;
    Widget_gizmo*       _wgt_gizmo;
    Widget_render_mode* _wgt_rd_mode;
    Widget_fitting*     _wgt_fit;
    /// ComboBox to choose the pivot mode of the camera
    QComboBox*          _pivot_comboBox;
    /// Pivot of the gizmo
    QComboBox*          _pivot_gizmo_comboBox;
    /// orientation of the gizmo
    QComboBox*          _dir_gizmo_comboBox;

public slots:

signals:

private:

};

#endif // TOOLBAR_HPP__
