/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef TOOLBAR_PAINTING_HPP__
#define TOOLBAR_PAINTING_HPP__

#include <QToolBar>
#include <QComboBox>
#include <QCheckBox>

#include "common/toolbars/widget_painting_floats.hpp"


class Toolbar_painting : public QToolBar {
    Q_OBJECT

public:
    Toolbar_painting(QWidget *parent);
    ~Toolbar_painting();

    bool is_paint_on() const { return _enable_paint->isChecked(); }

    QCheckBox* _enable_paint;
    Widget_painting* _paint_widget;

public slots:

private:
    QComboBox* _paint_mode_comboBox;
};




#endif // TOOLBAR_PAINTING_HPP__
