/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef _MAIN_WINDOW_SKIN2_H_
#define _MAIN_WINDOW_SKIN2_H_

#include <QComboBox>
#include <QSlider>
#include <QKeyEvent>
#include <map>

#include "ui_main_window.h"

#include "OGL_widget.hpp"

// FORWARD DEFS ----------------------------------------------------------------
// Forward def because of the interdependencie between MainWindow and
// OGL_viewports
class OGL_viewports;
// END FORWARD DEFS ------------------------------------------------------------

/** @class MainWindow
  @brief The qt main window

  The window is designed through a '.ui' slots and signals are handle here.
  The class is implemented through severals main_window_xxx.cpp to seperate
  different parts of the window implementation wich is large
*/
class Main_window : public QMainWindow, public Ui::MainWindow {
    Q_OBJECT

public:
    Main_window(QWidget *parent = NULL);

    void choose_hrbf_samples(int bone_id);
    void choose_hrbf_samples_selected_bones();

    /// Set the controller for the current selected bone given the spinBox
    /// values
    void set_current_ctrl();

    /// Wether activate/or deactivate GUI related to animesh
    void enable_gui_animesh(bool state);

    /// Wether activate/or deactivate GUI related to mesh
    void enable_gui_mesh(bool state);

    void keyPressEvent( QKeyEvent* event );

    void keyReleaseEvent( QKeyEvent* event );

private:

    // -------------------------------------------------------------------------
    /// @name Widgets setup
    // -------------------------------------------------------------------------
    /// Initialize attributes to safe values
    void setup_attrs();
    /// Populate the toolbar
    void setup_toolbar();
    /// Populate '_viewports'
    void setup_viewports();
    /// Hard coded window properties
    void setup_main_window();

    // -------------------------------------------------------------------------
    /// @name Tools
    // -------------------------------------------------------------------------

    /// Loads a mesh into the scene. This check the file extension and add
    /// every meshes (and <b>only</b> meshes) to the scene.
    /// look to #Base_loader class for the list of supported file formats
    void load_mesh(const QString& str);

    /// Loads an FBX file into the scene (meshes, skeleton, etc. )
    void load_fbx(const QString& str);

    // -------------------------------------------------------------------------
    /// @name Attributes
    // -------------------------------------------------------------------------

    /// ComboBox to choose the type of selection (circle, square etc.)
    QComboBox* _selection_comboBox;

    /// The openGL viewports
    OGL_viewports* _viewports;

    /// @name special key states
    bool _is_ctrl_pushed;   ///< is control key pushed
    bool _is_alt_pushed;    ///< is alt key pushed
    bool _is_tab_pushed;    ///< is tabulation key pushed
    bool _is_maj_pushed;    ///< is shift key pushed
    bool _is_space_pushed;  ///< is space key pushed

public slots:
    // -------------------------------------------------------------------------
    /// @name MANUAL SLOTS
    // -------------------------------------------------------------------------

    /// Redraw all opengl viewports
    void update_viewports();
    /// Enable disable painting mode
    void paint_toggled(bool state);
    /// Update GUI relative to the active viewport
    void active_viewport(int id);

    void selection_toolb_point();
    void selection_toolb_circle();
    void selection_toolb_square();
    void viewport_toolb_single();
    void viewport_toolb_doubleV();
    void viewport_toolb_doubleH();
    void viewport_toolb_four();
    void rd_mode_toolb_tex();
    void rd_mode_toolb_solid();
    void rd_mode_toolb_wire();
    void rd_mode_toolb_wire_transc();
    void show_all_gizmo(bool checked);
    void set_gizmo_trans();
    void set_gizmo_rot();
    void set_gizmo_trackball();
    void set_gizmo_scale();
    void toggle_fitting(bool checked);
    void pivot_comboBox_currentIndexChanged(int index);
    void gizmo_dir_comboBox_currentIndexChanged(int index);
    void gizmo_pivot_comboBox_currentIndexChanged(int index);


    // -------------------------------------------------------------------------
    /// @name AUTO SLOTS
    // -------------------------------------------------------------------------
    void on_actionExit_triggered();
    void on_dSpinB_near_plane_valueChanged(double arg1);
    void on_dSpinB_far_plane_valueChanged(double arg1);


private slots:
    void on_actionLoad_Obj_triggered();
    void on_spinBox_valueChanged(int arg1);
    void on_spinB_aperture_valueChanged(int arg1);
};

#endif // _MAIN_WINDOW2_H_
