/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "main_window.hpp"

#include "point_cache_export.hpp"
#include "OGL_viewports.hpp"
#include "qt_gui/common/tools/popup_ok_cancel.hpp"

// -----------------------------------------------------------------------------

void Main_window::keyPressEvent( QKeyEvent* event )
{
    // Check special keys
    switch( event->key() ){
    case Qt::Key_Control: _is_ctrl_pushed = true; break;
    case Qt::Key_Alt:     _is_alt_pushed  = true; break;
    case Qt::Key_Tab:     _is_tab_pushed  = true; break;
    case Qt::Key_Shift:   _is_maj_pushed  = true; break;
    case Qt::Key_Space:   _is_space_pushed= true; break;
    }

    //OGL_widget* wgl = _viewports->active_viewport();

    if( _is_ctrl_pushed && _is_space_pushed )
    {
        Widget_gizmo* gizmo = toolBar->_wgt_gizmo;
        gizmo->toolB_show_gizmo->setChecked( !gizmo->toolB_show_gizmo->isChecked() );
    }

    // Check standard characters :
    /*
    QString t = event->text();
    QChar c = t[0];
    switch (c.toAscii()) {
    // deprecated
    //case 'g': _display._grid = !_display._grid; break;
    }
    */

    // escape key :
    if( event->key() == Qt::Key_Escape )
    {
#if 0
        Diag_ok_cancel diag("Leave ?",
                            "Do you really want to leave this awesome app ?",
                            this);
        if( diag.exec() )
#endif
            close();
    }

    _viewports->updateGL();
}

// -----------------------------------------------------------------------------

void Main_window::keyReleaseEvent( QKeyEvent* event )
{
    // Check special keys
    switch( event->key() ){
    case Qt::Key_Control: _is_ctrl_pushed = false; break;
    case Qt::Key_Alt:     _is_alt_pushed  = false; break;
    case Qt::Key_Tab:     _is_tab_pushed  = false; break;
    case Qt::Key_Shift:   _is_maj_pushed  = false; break;
    case Qt::Key_Space:   _is_space_pushed= false; break;
    }
}

// -----------------------------------------------------------------------------
