/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef DEPTH_PEELING_HPP__
#define DEPTH_PEELING_HPP__

#include "glassert.h"
#include "glbuffer_object.hpp"
#include "shader.hpp"

/** These function performs depth peeling so that transparency is rendered in
    the right way
 */


/** The class that performs depth peeling with alpha blending
    @note : for now hardware antialiasing won't work with this because of
    the use of FBOs
*/
struct Peeler{

    class Render{
    public:
        virtual ~Render() {}
        /// Method to override in order to do the depth peeling of some objects
        virtual void draw_transc_objs() = 0;
    };

    Peeler();
    ~Peeler();

    /// Sets the function used to draw the objects with depth peeling
    void set_render_func(Render* r);

    /// Draw a fullscreen quad
    static void draw_quad();

    /// Initialize color and depth buffers prior to depth peeling
    void set_background(int width, int height,
                        const GlBuffer_obj* pbo_color,
                        const GlBuffer_obj* pbo_depth);

    /// Do depth peelign with alpha blending
    void peel(float base_alpha);

    /// Initialize buffers
    void init_depth_peeling(int width, int height);

    /// Initialize buffers again (when window is resized)
    void reinit_depth_peeling(int width, int height);

    /// Erase textures FBO etc.
    void erase_gl_mem();

    // buffers used for depth peeling
    bool   _is_init;
    GLuint _depthTexId[2];
    GLuint _colorTexId[2];
    GLuint _fboId[2];
    GLuint _colorBlenderTexId;
    GLuint _colorBlenderFboId;
    GLuint _backgroundColorTexId;
    GLuint _backgroundDepthTexId;

    Render* _renderer;
};

#endif // DEPTH_PEELING_HPP__
