/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef FILL_GRID_THREAD_HPP__
#define FILL_GRID_THREAD_HPP__

#include <QRunnable>

#include "idx3_cu.hpp"
#include <vector>

#include "scene_tree/implicit_surfaces/node_implicit_surface.hpp"

// =============================================================================
namespace Marching_cubes {
// =============================================================================

/**
 * @class Fill_grid_thread
 * @brief thread encapsulation to fill a sub part of a 3d grid with a
 * potential field
 *
 *
 */
class Fill_grid_thread : public QRunnable {
public:

    /// @param sub_res_ : size of the sub grid to be looked up
    /// @param offset_ : offset inside the grid from which we start the look up
    /// @param world_resolution_ : size of the actual grid (ie. data_field_)
    /// @param box_start_ : 3d position of the grid in the scene.
    /// @param world_step_ : lengths of the grid's cells
    /// @param data_field_ : the 3d grid stored linearly of size
    /// world_resolution_.x * world_resolution_.y * world_resolution_.z
    /// @param obj_ : the implicit objet / tree with which we fill the grid
    /// with its scalar values.
    Fill_grid_thread(Vec3i_cu sub_res_,
                     Vec3i_cu offset_,
                     Vec3i_cu world_resolution_,
                     Vec3_cu box_start_,
                     Vec3_cu world_step_,
                     std::vector<float>& data_field_,
                     const Node_implicit_surface* obj_);

protected:
    /// Look up the sub-grid and fill it
    void run();

    Vec3i_cu _sub_res;
    Vec3i_cu _offset;

    Vec3i_cu _world_resolution;
    Vec3_cu _box_start;
    Vec3_cu _world_step;

    std::vector<float>& _data_field;
    const Node_implicit_surface* _obj;
};

}// END MARCHING_CUBE ==========================================================

#endif // FILL_GRID_THREAD_HPP__
