/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef TABLES_MCUBE_H
#define TABLES_MCUBE_H

// =============================================================================
namespace Marching_cubes {
// =============================================================================

/// Edge list of an intersected cube cell with 8bits for each vertex of the cell
/// A bit set to 1 means the vertex is inside the iso-surface.
extern int g_edge_table[256];

/// Given the edge table index gives the triangel configuration.
/// The list of 16 elements is the adjacency between the vertices.
extern int g_tri_table[256][16];

}// END MARCHING_CUBES =========================================================

#endif // TABLES_MCUBE_H
