/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef MARCHING_CUBES_CPU_HPP__
#define MARCHING_CUBES_CPU_HPP__

#include "scene_tree/implicit_surfaces/node_implicit_surface.hpp"
#include "vec3_cu.hpp"
#include "vec3i_cu.hpp"

// =============================================================================
namespace Marching_cubes {
// =============================================================================

class Cell{
public:
    float   val[8]; ///< value at each cube's corner
    Vec3_cu pos[8]; ///< cube positions
};

/// Software marching cubes polygonization
/// Slow as hell because we use gl direct mode in addition of
/// the CPU calculation...
void direct_mode_render_marching_cubes(const Node_implicit_surface* node,
                                       const Vec3_cu world_start,
                                       Vec3i_cu res,
                                       Vec3_cu steps,
                                       float iso_lvl);

}// END MARCHING_CUBE ==========================================================

#endif // MARCHING_CUBES_CPU_HPP__
