/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef OPENGL_STUFF_HPP__
#define OPENGL_STUFF_HPP__

#include "port_glew.h"
#include "camera.hpp"

/** Various OpenGL functions
 */

/// Enable the program used to display a textured quad
void EnableProgram();
/// Disable that program
void DisableProgram();

/// Initialize various OpenGL states, buffer objects, textures...
void init_opengl();

/// Draw a quad to paint on
void draw_quad();

GLuint init_tex_operator( int width, int height );

void load_shaders();

void erase_shaders();

/// Draw a circle on screen at position (x, y)  of radius rad
void draw_circle(int width, int height, int x, int y, float rad);

void draw_grid_lines(const Camera* cam);

#endif // OPENGL_STUFF_HPP__
