/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "render_context.hpp"

#include <vector>
#include "gltex2D.hpp"
#include "glpick_fbo.hpp"

// -----------------------------------------------------------------------------

Render_context::Render_context(int w, int h):
    _pbo_color(0),
    _pbo_depth(0)
{
    _peeler    = new Peeler();
    _frame_tex = new GlTex2D(w, h, 0, GL_LINEAR, GL_CLAMP, GL_RGBA);
    _picker    = new GlPick_FBO(w, h);

    allocate(w, h);
}

// -----------------------------------------------------------------------------

Render_context::~Render_context()
{
    delete _pbo_color;
    delete _pbo_depth;
    delete _frame_tex;
    delete _peeler;
    delete _picker;
}

// -----------------------------------------------------------------------------

void Render_context::reshape(int w, int h)
{
    allocate(w, h);
}

// -----------------------------------------------------------------------------

void Render_context::allocate(int width, int height)
{
    _width  = width;
    _height = height;

    _frame_tex->bind();
    _frame_tex->set_size(width, height);
    _frame_tex->allocate(GL_UNSIGNED_BYTE, GL_RGBA);
    GlTex2D::unbind();

    std::vector<float> empty_color(width * height * 4/*for all rgba channels*/, 0.f);
    if( _pbo_color != 0 ) _pbo_color->set_data(width * height, &(empty_color[0]) );
    else                  _pbo_color = new GlBuffer_obj(width * height, GL_PIXEL_UNPACK_BUFFER);

    std::vector<float> empty_depth(width * height, 1.f);
    if(_pbo_depth != 0) _pbo_depth->set_data(width * height, &(empty_depth[0]) );
    else                _pbo_depth = new GlBuffer_obj(width * height, GL_PIXEL_UNPACK_BUFFER);

    _peeler->reinit_depth_peeling(width, height);

    _picker->resize(width, height);
}

// -----------------------------------------------------------------------------
