/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef RENDER_CONTEXT_HPP_
#define RENDER_CONTEXT_HPP_

#include "depth_peeling.hpp"

class GlTex2D;
class GlPick_FBO;

/// @class Render_context
/// @brief Holds rendering context (image buffers pbos textures) for a single
/// viewport
class Render_context {
public:

    Render_context(int w, int h);

    ~Render_context();

    void reshape(int w, int h);
    void allocate(int width, int height);

    // -------------------------------------------------------------------------
    /// @name Getters & setters
    // -------------------------------------------------------------------------

    int width()  const { return _width;  }
    int height() const { return _height; }

    GlBuffer_obj* pbo_color(){ return _pbo_color; }
    GlBuffer_obj* pbo_depth(){ return _pbo_depth; }

    GlTex2D* frame_tex(){ return _frame_tex; }

    Peeler* peeler(){ return _peeler; }

    GlPick_FBO* picker(){ return _picker; }

private:
    // -------------------------------------------------------------------------
    /// @name Datas
    // -------------------------------------------------------------------------
    int _width, _height;

    GlPick_FBO* _picker; ///< Fbo for picking primitives

    /// The pbo that contains the result of the raytracing done by cuda
    GlBuffer_obj* _pbo_color;
    GlBuffer_obj* _pbo_depth;

    GlTex2D* _frame_tex;

    Peeler* _peeler;
};

#endif // RENDER_CONTEXT_HPP_
