/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef NODE_IMPLICIT_SURFACE_HPP__
#define NODE_IMPLICIT_SURFACE_HPP__

#include "bbox.hpp"
#include "vec3_cu.hpp"

class Node_implicit_surface {
public:

    Node_implicit_surface(){ }
    virtual ~Node_implicit_surface(){ }

    virtual float f(const Vec3_cu& pos) const = 0;
    virtual Vec3_cu gf(const Vec3_cu& pos) const = 0;
    virtual float fngf(const Vec3_cu& pos, Vec3_cu& grad) const = 0;

    virtual BBox_cu get_bbox() const = 0;
};


#endif // NODE_IMPLICIT_SURFACE_HPP__
