/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "obj_mesh.hpp"

// -----------------------------------------------------------------------------

Obj_mesh::Obj_mesh() : Obj()
{
    _render_type = PEEL;
    set_state(WIRES, true);
}

// -----------------------------------------------------------------------------

Obj_mesh::~Obj_mesh(){ }

// -----------------------------------------------------------------------------

void Obj_mesh::load(const Loader::Abs_mesh& mesh)
{
    _mesh.load( mesh );
    //_mesh.center_and_resize(50.f);
    _mesh.check_integrity();

    //Color cl = Cuda_ctrl::_color.get(Color_ctrl::MESH_POINTS);-----------------------------
    //_mesh->set_point_color_bo(cl.r, cl.g, cl.b, cl.a);

    //delete g_anim_cache;
    //g_anim_cache = new Point_cache_file(g_mesh->get_nb_vertices(), 100);-----------------------------

    std::cout << "mesh loaded" << std::endl;
}

// -----------------------------------------------------------------------------

void Obj_mesh::draw()
{
    if( !_use_shader )
        _mesh.draw(false);
    else
    {
        if( _render_type == PEEL)
            _mesh.draw();
        else
        {
            glColor3f(1.f, 1.f, 1.f);
            Mesh::Material mat;
            mat.setup_opengl_materials();

            Mesh_renderer::draw(_mesh, _mesh._vbo, _mesh._normals_bo, state(MATERIALS) );
        }
    }
}

// -----------------------------------------------------------------------------

Data* Obj_mesh::clone() const{
    return 0;
}
