/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef OBJ_MESH_HPP__
#define OBJ_MESH_HPP__

#include "object.hpp"
#include "mesh.hpp"
#include "mesh_renderer.hpp"

/**
 * @brief Mesh representation in the scene graph for drawing and picking
 */
class Obj_mesh : public Obj {
public:

    Obj_mesh();

    ~Obj_mesh();

    EObj::Obj_t type_object() const { return EObj::MESH; }

    /// Load the mesh from an abstract representation.
    /// @see Loader
    void load(const Loader::Abs_mesh& mesh);

    /// Save a mesh into the abstract representation
    void save(Loader::Abs_mesh& mesh){ _mesh.save( mesh ); }

    void draw();

    Data* clone() const;

    // =========================================================================
    /// @name Getter & Setters
    // =========================================================================

    const Mesh& get_mesh() const { return _mesh; }

private:
    // =========================================================================
    /// @name attributes
    // =========================================================================

    Mesh      _mesh;
};

#endif // OBJ_MESH_HPP__
