/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "object.hpp"

bool Obj::_use_shader = true;

// -----------------------------------------------------------------------------

Transfo Obj::global_frame() const
{
    // We don't intend to actually change 'this'
    // but we need pointer 'o' to change
    Obj* o = const_cast<Obj*>(this);
    Transfo tr = Transfo::identity();
    while(o != 0){
        tr = o->_frame_lcl * tr;
        o = o->_parent;
    }

    return tr;
}

// -----------------------------------------------------------------------------

void Obj::transform(const Transfo& transfo)
{
    Obj* obj = this;
    Transfo global_pt = obj->parent()->global_frame();
    Transfo tr = global_pt.fast_invert() * transfo * global_pt;
    obj->_frame_lcl = tr * obj->_frame_lcl;
}

// -----------------------------------------------------------------------------

void Obj::set_transform(const Transfo& transfo)
{
    Obj* obj = this;
    Transfo global_pt = obj->parent()->global_frame();
    Transfo tr = global_pt.fast_invert() * transfo;
    obj->_frame_lcl = tr;
}

// -----------------------------------------------------------------------------
