/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef OBJECT_ENUM_HPP__
#define OBJECT_ENUM_HPP__

// =============================================================================
namespace EObj {
// =============================================================================

/// @brief Bit field of Obj_t or Mode_t
typedef int Flags;

/// @brief objects types in the scene graph
/// @note enum can be used as bit fields
enum Obj_t {
    IMPLICIT      = 1,
    MESH          = 2,
    SKELETON      = 4,
    SPRITE        = 8,
    LIGHT_SPOT    = 16,
    NONE          = 32
};

/// @brief objects modes (this defines the io behaviour depending on the object mode)
/// @note enum can be used as bit fields
enum Mode_t {
    MODE_POSE   = 1,
    MODE_EDIT   = 2,
    MODE_OBJECT = 4,
    MODE_PAINT  = 8
};

/// test a flag inside the bit field Obj_flags
template<typename E>
static inline bool test(Flags flags, E a_flag){ return (flags & a_flag) != 0; }

/// enable flag
template<typename E>
static inline void set_on(Flags& flags, E f){ flags = (flags | f); }

/// disable flag
template<typename E>
static inline void set_off(Flags& flags, E f){ flags = (flags & (~f)); }

}// END NAMESPACE EObj =========================================================

#endif // OBJECT_ENUM_HPP__
