/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef PICKER_IO_HPP__
#define PICKER_IO_HPP__

#include <QMouseEvent>

class IO_Selection;

/**
 * @class Picker_io
 * @brief Defines specialized inputs/outputs for objects
 *
 * Basic object manipulation is already defined in classes such as IO_interface,
 * IO_manipulation, IO_selection etc. But sometimes you need to define a
 * specific IO behavior. This class provides an interface to specialize the IO.
 *
 * Simply inherit and implement the needed functions. By default IO events will
 * try to use this class if the IO event is not handled then we fallback to the
 * default behavior.
 *
 */
class Picker_io {
public:
    Picker_io() : _io_selection(0) {}
    virtual ~Picker_io() {}

    // -------------------------------------------------------------------------
    /// @name Events handlers
    /// @brief return false if the event is ignored or true if handled.
    /// The default IO behavior will be used if false is returned
    // -------------------------------------------------------------------------

    virtual bool mouse_press  (QMouseEvent* ){ return false; }
    virtual bool mouse_release(QMouseEvent* ){ return false; }
    virtual bool mouse_move   (QMouseEvent* ){ return false; }
    virtual bool wheel        (QWheelEvent* ){ return false; }
    virtual bool key_press    (QKeyEvent*   ){ return false; }
    virtual bool key_release  (QKeyEvent*   ){ return false; }

protected:
    friend class IO_Selection;
    /// This ought to be updated before each key/mouse event by the
    /// IO propagating the event (which for the moment is
    /// solely the IO_Selection class).
    /// @note in the future we could use a proper IO interface so that any
    /// IO class can update this pointer
    IO_Selection* _io_selection;

};

#endif // PICKER_IO_HPP__
