/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef ASSERT_UTILS_HPP__
#define ASSERT_UTILS_HPP__

#include <cassert>

/// @def assert_msg
/// @brief asserts and print a message if triggered
#ifndef NDEBUG
#define assert_msg(a, str)                  \
do{                                         \
    if(!(a)){                               \
        std::cerr << (str) << std::endl;    \
        assert((a));                        \
    }                                       \
}while(0)

#else
#define assert_msg(a, str)
#endif

#endif // ASSERT_UTILS_HPP__
