/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CHRONO_H
#define CHRONO_H

#include <string>

/** @class Chrono
    @brief tool class for measuring exact process consumption time (unix rusage)
    The measured time correspond only to the time spend inside the process
*/
class Chrono
{
public:
    Chrono();

    /// start or restart chrono
    void start();

    /// Print elapsed time with a message
    void elapsedTime(std::string msge);

    double _start_time;
    double _end_time;
    double _delay;
};

#endif // CHRONO_H
