/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef GRID_ENUMS_HPP__
#define GRID_ENUMS_HPP__

// TODO: namespace

struct Range {
    Range() : _dyn_range(true), _a(0), _b(-1) { }

    /// @param start, end: staring index and end index (both included)
    Range(int start, int end) : _dyn_range(false), _a( start ), _b( end+1 ) { }

    int nb_elts() const { return _b-_a; }

    /// If false you should not consider _a and _b but the size of the object
    bool _dyn_range;

    int _a; ///< starting index (included)
    int _b; ///< last index (excluded)
};

// !!! WARNING:
//  Really dangerous: if defined before any code with an "A", it will be replaced
//                    (ex: "int A", "template<typename A>" ...)
#ifndef A
#define A Range()
#else
#error "symbol A is already defined"
#endif

#endif // GRID_ENUMS_HPP__
