/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CONVERSIONS_HPP__
#define CONVERSIONS_HPP__

#include "point_cu.hpp"
#include "vec3_cu.hpp"


// =============================================================================
namespace Convs {
// =============================================================================
// TODO: to be deleted (redundant with functions in Vec3_cu and Point_cu)
IF_CUDA_DEVICE_HOST
static inline Point_cu to_point(const Vec3_cu& v){
  return Point_cu(v.x, v.y, v.z);
}

/// Convert a Point_cu to a CUDA vector
IF_CUDA_DEVICE_HOST
static inline Vec3_cu to_vector(const Point_cu& v){
  return Vec3_cu(v.x, v.y, v.z);
}

}
// END Convert NAMESPACE =======================================================

#endif // CONVERSIONS_HPP__
