/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CUDA_UTILS_COMMON_HPP__
#define CUDA_UTILS_COMMON_HPP__

#include <cassert>
#include <vector>
#include <cuda_runtime_api.h>
#include <cuda_runtime.h>
#include "cuda_compiler_interop.hpp"
#include "cuda_assert.hpp"
#include "cuda_utils_memory_hanlding.hpp"

/** @namespace Cuda_utils::Common
    @brief Base structures to work on both device and host arrays

    This file is part of the Cuda_utils homemade toolkit it provides common
    feature for device and host arrays

    @see Cuda_utils
*/

// =============================================================================
namespace Cuda_utils{
// =============================================================================

// =============================================================================
namespace Common{
// =============================================================================

/** @brief Mother class for Host and Device arrays of Cuda_utils namespace
    @see Cuda_utils Cuda_utils::Host::Array Cuda_utils::Device::Array
*/
template <class T>
struct Array{
    IF_CUDA_DEVICE_HOST
    inline int	size() const { return nb_elt; }

protected:
    IF_CUDA_DEVICE_HOST
    inline Array() : nb_elt(0) {}
    IF_CUDA_DEVICE_HOST
    inline Array(int i) : nb_elt(i) {}
    int nb_elt;
    enum{
        IS_ALLOCATED = 1,
        IS_COPY = 2        ///< If on the array won't be freed at destruction
    };
};

}// END COMMON NAMESPACE =======================================================

}// END CUDA_UTILS NAMESPACE ===================================================

#endif // CUDA_UTILS_COMMON_HPP__
