/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CUDA_UTILS_TRAITS_HPP__
#define CUDA_UTILS_TRAITS_HPP__

/**
 * @file cuda_utils_traits.hpp
 * @brief Compile time error checking utilities
 *
 * C++0x introduce #include <type_traits> header with some usefull utilities
 * which we re-implement here without the need of doing C++0x.
 */

// =============================================================================
namespace Cuda_utils{
// =============================================================================

/////////////////////////////////////////////////////////
// Implementation note:
// Shameless copy past of a piece of a thrust lib header:
// #include <thrust/detail/type_traits.h>
// If the implementation looks weird don't worry
// its normal its just ugly MetaProgramming stuff
/////////////////////////////////////////////////////////

/// @class integral_constant
/// @brief helper classes of this header not meant to an external usage
template<typename _Tp, _Tp __v>
  struct integral_constant
  {
    static const _Tp                      value = __v;
    typedef _Tp                           value_type;
    typedef integral_constant<_Tp, __v>   type;
  };

/// typedef for true_type
typedef integral_constant<bool, true>     true_type;
/// typedef for true_type
typedef integral_constant<bool, false>    false_type;


/**
 * @class is_same
 * @brief Tell if two types are identical (compile time checking)
 * usage:
 * @code
 * {
 *      // this print false
 *      std::cout << Cuda_utils::is_same<bool, int>::value;
 *      // while this print true
 *      std::cout << Cuda_utils::is_same<bool, bool>::value;
 * }
 * @endcode
 */
template<typename T1, typename T2>
struct is_same : public false_type{ };

template<typename T>
struct is_same<T,T> : public true_type { };

} // END CUDA_UTILS NAMESPACE ==================================================

#endif // CUDA_UTILS_TRAITS_HPP__
