/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CUDA_UTILS_TYPEDEFS_HPP__
#define CUDA_UTILS_TYPEDEFS_HPP__


#include "cuda_utils_device_array.hpp"
#include "cuda_utils_host_array.hpp"
#include "cuda_utils_hd_array.hpp"

#include "vec3_cu.hpp"  
#include "point_cu.hpp"

// =============================================================================
namespace Cuda_utils{
// =============================================================================

/// @name Typenames shortcuts for common types
/// @{
// Device arrays
typedef Device::Array<int> DA_int;
typedef Device::Array<bool> DA_bool;
typedef Device::Array<int2> DA_int2;
typedef Device::Array<int3> DA_int3;
typedef Device::Array<int4> DA_int4;
typedef Device::Array<unsigned> DA_uint;
typedef Device::Array<uint2> DA_uint2;
typedef Device::Array<uint3> DA_uint3;
typedef Device::Array<uint4> DA_uint4;
typedef Device::Array<float > DA_float;
typedef Device::Array<float2> DA_float2;
typedef Device::Array<float3> DA_float3;
typedef Device::Array<float4> DA_float4;
typedef Device::Array<Vec3_cu> DA_Vec3_cu;
typedef Device::Array<Vec2_cu> DA_Vec2_cu;
typedef Device::Array<Point_cu> DA_Point_cu;

// Host arrays
typedef Host::Array<int> HA_int;
typedef Host::Array<bool> HA_bool;
typedef Host::Array<int2> HA_int2;
typedef Host::Array<int3> HA_int3;
typedef Host::Array<int4> HA_int4;
typedef Host::Array<unsigned> HA_uint;
typedef Host::Array<uint2> HA_uint2;
typedef Host::Array<uint3> HA_uint3;
typedef Host::Array<uint4> HA_uint4;
typedef Host::Array<float > HA_float;
typedef Host::Array<float2> HA_float2;
typedef Host::Array<float3> HA_float3;
typedef Host::Array<float4> HA_float4;
typedef Host::Array<Vec3_cu> HA_Vec3_cu;
typedef Host::Array<Vec2_cu> HA_Vec2_cu;
typedef Host::Array<Point_cu> HA_Point_cu;

// Page locked host arrays
typedef Host::PL_Array<int> HAPL_int;
typedef Host::PL_Array<bool> HAPL_bool;
typedef Host::PL_Array<int2> HAPL_int2;
typedef Host::PL_Array<int3> HAPL_int3;
typedef Host::PL_Array<int4> HAPL_int4;
typedef Host::PL_Array<int > HAPL_uint;
typedef Host::PL_Array<uint2> HAPL_uint2;
typedef Host::PL_Array<uint3> HAPL_uint3;
typedef Host::PL_Array<uint4> HAPL_uint4;
typedef Host::PL_Array<float > HAPL_float;
typedef Host::PL_Array<float2> HAPL_float2;
typedef Host::PL_Array<float3> HAPL_float3;
typedef Host::PL_Array<float4> HAPL_float4;
typedef Host::PL_Array<Vec3_cu> HAPL_Vec3_cu;
typedef Host::PL_Array<Vec2_cu> HAPL_Vec2_cu;
typedef Host::PL_Array<Point_cu> HAPL_Point_cu;

// Device/Host arrays
typedef HD_Array<int> HDA_int;
typedef HD_Array<bool> HDA_bool;
typedef HD_Array<int2> HDA_int2;
typedef HD_Array<int3> HDA_int3;
typedef HD_Array<int4> HDA_int4;
typedef HD_Array<int > HDA_uint;
typedef HD_Array<uint2> HDA_uint2;
typedef HD_Array<uint3> HDA_uint3;
typedef HD_Array<uint4> HDA_uint4;
typedef HD_Array<float > HDA_float;
typedef HD_Array<float2> HDA_float2;
typedef HD_Array<float3> HDA_float3;
typedef HD_Array<float4> HDA_float4;
typedef HD_Array<Vec3_cu> HDA_Vec3_cu;
typedef HD_Array<Vec2_cu> HDA_Vec2_cu;
typedef HD_Array<Point_cu> HDA_Point_cu;
/// @}

}// END CUDA_UTILS NAMESPACE ===================================================

#endif // CUDA_UTILS_TYPEDEFS_HPP__
