/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CUDA_UTILS_VEC_EXPR_INL__
#define CUDA_UTILS_VEC_EXPR_INL__

#include "cuda_utils_vec_expr.hpp"
#include "cuda_utils_vec_expr_miscellaneous.hpp"

// =============================================================================
namespace Cuda_utils {
// =============================================================================

//------------------------------------------------------------------------------
// Define binnary overloaded operators
// ( Vec_expr<?> bin_op(Vec_expr<T1>, Vec_expr<T2>) )
// By default the returned type is the left hand side so that '?' == 'T1'.
// If you want the right hand side to be the returned type then add the line:
// DEFINE_BIN_OP_SPECIAL_RET_TYPE(op_name, ret_type, left_arg, right_arg);
//------------------------------------------------------------------------------

DEFINE_BIN_OP(Vec_mult, *);
DEFINE_BIN_OP_DEFAULT_RET_TYPE(Vec_mult, BIN_OP_LEFT_ARG);
DEFINE_BIN_OP_SPECIAL_RET_TYPE(Vec_mult, Vec3_cu, Transfo, Vec3_cu);

DEFINE_BIN_OP(Vec_diff, -);
DEFINE_BIN_OP_DEFAULT_RET_TYPE(Vec_diff, BIN_OP_LEFT_ARG);

DEFINE_BIN_OP(Vec_plus, +);
DEFINE_BIN_OP_DEFAULT_RET_TYPE(Vec_plus, BIN_OP_LEFT_ARG);

DEFINE_BIN_OP(Vec_div, /);
DEFINE_BIN_OP_DEFAULT_RET_TYPE(Vec_div, BIN_OP_LEFT_ARG);

DEFINE_BIN_OP(Vec_modulo, %);
DEFINE_BIN_OP_DEFAULT_RET_TYPE(Vec_modulo, BIN_OP_LEFT_ARG);

//------------------------------------------------------------------------------
// Define rhs bin operators ( Vec_expr<T> rhs_bin_op(Vec_expr<T>, base_type) )
// base_type =  {double, float, int, unsigned, long}
//------------------------------------------------------------------------------

DEFINE_BIN_OP_RHS_BASE_TYPE_OVERLOAD_ALL(Vec_scale_right, *);
DEFINE_BIN_OP_RHS_BASE_TYPE_OVERLOAD_ALL(Vec_incr_right , +);
DEFINE_BIN_OP_RHS_BASE_TYPE_OVERLOAD_ALL(Vec_decr_right , -);

//------------------------------------------------------------------------------
// Define generic map functions ( Vec_expr<T> map(Vec_expr<T>) )
// Note: you can define new functions in Cuda_utils::details namspace and add
// the a definition here DEFINE_GENERIC_MAP(my_func);
// @see cuda_utils_vec_expr_miscellaneous.hpp
//------------------------------------------------------------------------------

DEFINE_GENERIC_MAP(incr);
DEFINE_GENERIC_MAP(sin);
DEFINE_GENERIC_MAP(cos);
DEFINE_GENERIC_MAP(tan);
DEFINE_GENERIC_MAP(exp);
DEFINE_GENERIC_MAP(log);
/*
 TODO: to be tested
DEFINE_GENERIC_MAP(sqrt);
DEFINE_GENERIC_MAP(pow);
DEFINE_GENERIC_MAP(fabs);
*/

//------------------------------------------------------------------------------
// Define generic map functions with 2 args
// ( Vec_expr<T> map(Vec_expr<T>, T, T) )
//------------------------------------------------------------------------------

DEFINE_GENERIC_MAP_2ARGS(clamp);

// -----------------------------------------------------------------------------
// Define element wise operations on Vector types (Vec3_cu, Vec2_cu  etc.)
// Return type is predefined
// -----------------------------------------------------------------------------

DEFINE_MAP(norm, float);
DEFINE_MAP(norm_squared, float);

DEFINE_BIN_OP_FUNC(dot, float);
DEFINE_BIN_OP_FUNC(cross, Vec3_cu);


}// END NAMESPACE CUDA_UTILS ===================================================


#endif // CUDA_UTILS_VEC_EXPR_INL__
