/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef CUDA_UTILS_VEC_EXPR_MISCELLANEOUS__
#define CUDA_UTILS_VEC_EXPR_MISCELLANEOUS__

#include "cuda_compiler_interop.hpp"
#include "math_cu.hpp"
#include "transfo.hpp"
#include "vec3_cu.hpp"
#include "vec2_cu.hpp"
/**
 * @file cuda_utils_vec_expr_miscellaneous.hpp
 * @brief various utilities function wrapping for template expressions
 * @see cuda_utils_vec_expr.inl
 */
// =============================================================================
namespace Cuda_utils {
// =============================================================================

// =============================================================================
namespace details {
// =============================================================================

    /// An internal generic version of max
    template <typename Real_t>
    IF_CUDA_DEVICE_HOST inline
    Real_t max(Real_t a, Real_t b){ return a > b ? a : b; }

    /// An internal generic version of min
    template <typename Real_t>
    IF_CUDA_DEVICE_HOST inline
    Real_t min(Real_t a, Real_t b){ return a < b ? a : b; }

    template <typename Real_t>
    IF_CUDA_DEVICE_HOST inline
    Real_t clamp(Real_t x, Real_t a, Real_t b) { return max(a, min(b, x)); }

    /// An internal version of the norm
    IF_CUDA_DEVICE_HOST inline
    float norm(const Vec3_cu& v){ return v.norm(); }

    /// An internal version of the squared norm
    IF_CUDA_DEVICE_HOST inline
    float norm_squared(const Vec3_cu& v){ return v.norm_squared(); }

    /// An internal version of the norm
    IF_CUDA_DEVICE_HOST inline
    float norm(const Vec2_cu& v){ return v.norm(); }

    /// An internal version of the squared norm
    IF_CUDA_DEVICE_HOST inline
    float norm_squared(const Vec2_cu& v){ return v.norm_squared(); }

    /// An internal version of the dot product
    IF_CUDA_DEVICE_HOST inline
    float dot(const Vec3_cu& v1, const Vec3_cu& v2){ return v1.dot(v2); }

    /// An internal version of the dot product
    IF_CUDA_DEVICE_HOST inline
    float dot(const Vec2_cu& v1, const Vec2_cu& v2){ return v1.dot(v2); }

    /// An internal version of the cross product
    IF_CUDA_DEVICE_HOST inline
    Vec3_cu cross(const Vec3_cu& v1, const Vec3_cu& v2){ return v1.cross(v2); }

    /// Increment a generic real number
    template<typename Real>
    IF_CUDA_DEVICE_HOST
    Real incr(Real arg){ return arg + 1; }

}// END NAMESPACE DETAILS ======================================================

}// END NAMESPACE CUDA_UTILS ===================================================


#endif // CUDA_UTILS_VEC_EXPR_MISCELLANEOUS__
