/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "memory_debug.hpp"

// -----------------------------------------------------------------------------

void Memory_stack::push(const void* address,
                        size_t size,
                        const char* name,
                        Mem_kind type)
{
    if(n < stack_size){
        entries[n] = Mem_s(address, size, name, type);
        n++;
    } else {
        realloc();
        push( address, size, name, type);
    }
}

// -----------------------------------------------------------------------------

void Memory_stack::pop(const void* address)
{
    for(int i = 0; i < n; i++)
    {
        if(entries[i].address == address)
        {
            entries[i] = entries[--n];
            break;
        }
    }
}

// -----------------------------------------------------------------------------

void Memory_stack::print()
{
    printf("address\tkind\tsize(bytes)\tname\n");
    size_t total = 0;
    for(int i = 0; i < n; i++){
        Mem_s m = entries[i];
        printf("%p\t%s\t%d\t%s\n", m.address, (m.kind == CUDA_ARRAY)?"CA":"LM", static_cast<int>(m.size), m.name);
        total += m.size;
    }
    printf("%d elements\t\toccupancy: %d bytes\n",n,static_cast<int>(total));
}

// -----------------------------------------------------------------------------

void Memory_stack::realloc()
{
    Mem_s* new_entries = new Mem_s[2*stack_size];
    for(int i = 0; i < stack_size; i++){
        new_entries[i] = entries[i];
    }

    stack_size *= 2;

    delete[] entries;
    entries = new_entries;
}

// -----------------------------------------------------------------------------

int Memory_stack::n = 0;

int Memory_stack::stack_size = DEFAULT_STACK_SIZE;

Memory_stack::Mem_s* Memory_stack::entries = new Memory_stack::Mem_s[DEFAULT_STACK_SIZE];

// -----------------------------------------------------------------------------
