/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "port_cuda_gl_interop.h"
#include "cuda_utils.hpp"

#ifndef NDEBUG
#include <map>
std::map<GLuint, GLuint> registered;
#endif


void cuda_register_buffer_object (GLuint bufObj)
{
#ifndef NDEBUG
    static int acc = 0;
    // Check it has not already been registered
    std::map<GLuint, GLuint>::iterator it;
    it = registered.find(bufObj);
    assert(it == registered.end());
    registered[bufObj] = acc;
    acc++;
#endif

    CUDA_SAFE_CALL(cudaGLRegisterBufferObject(bufObj));
}

void cuda_unregister_buffer_object (GLuint bufObj)
{
#ifndef NDEBUG
    // Check it has been registered
    std::map<GLuint, GLuint>::iterator it;
    it = registered.find(bufObj);
    assert(it != registered.end());
    registered.erase(it);
#endif
    CUDA_SAFE_CALL(cudaGLUnregisterBufferObject(bufObj));
}

void cuda_map_buffer_object(void** devPtr, GLuint bufObj){
    CUDA_SAFE_CALL(cudaGLMapBufferObject(devPtr, bufObj));
}

void cuda_unmap_buffer_object(GLuint bufObj){
    CUDA_SAFE_CALL(cudaGLUnmapBufferObject(bufObj));
}
