/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "glu_utils.hpp"

#include "bbox.hpp"
#include "glsave.hpp"

// =============================================================================
namespace Gl_utils {
// =============================================================================

static void set_state(const Point_cu& p) { glVertex3f(p.x, p.y, p.z); }

// -----------------------------------------------------------------------------

void draw( const BBox_cu& bbox )
{
    GLEnabledSave light(GL_LIGHTING, true, false);
    GLEnabledSave tex2d(GL_TEXTURE_2D, true, false);
    GLEnabledSave tex3d(GL_TEXTURE_3D, true, false);

    // Draw bbox
    std::vector<Point_cu> c;
    bbox.get_corners( c );

    glBegin(GL_LINE_STRIP);
    set_state( c[0] ); set_state( c[1] ); set_state( c[5] );
    set_state( c[4] ); set_state( c[0] ); set_state( c[2] );
    set_state( c[3] ); set_state( c[7] ); set_state( c[6] );
    set_state( c[2] );
    glEnd();

    glBegin(GL_LINES);
    set_state( c[7] ); set_state( c[5] ); set_state( c[1] );
    set_state( c[3] ); set_state( c[4] ); set_state( c[6] );
    glEnd();
}


}// END GL_UTILS namespace =====================================================
