/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef OPENGL_SCREENSHOOTER_HPP__
#define OPENGL_SCREENSHOOTER_HPP__


#include <string>
#include <stdint.h>

/**
 * @class GlShoot
 * @brief Taking screenshots of the current openGl window
 *
 */
struct GlShoot {

  GlShoot(int size_x,
          int size_y,
          const std::string& dir_name,
          const std::string& file_name);

  ~GlShoot();

  /// Take screenshot
  void shoot();

  int get_frame_nb();

  void set_img_size(int size_x_, int size_y_);

private:

  void gl_shoot();
  char* get_file_name(const std::string& extension_) const;

  int      _size_x;
  int      _size_y;
  uint8_t* _buffer; ///< RGB data, on 1 byte each
  char*    _base_name;
  int      _frame_number;
};

#endif // OPENGL_SCREENSHOOTER_HPP__
