/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#include "glu_utils.hpp"

#include "port_glew.h"

// =============================================================================
namespace Glu_utils {
// =============================================================================


Vec3_cu project(Vec3_cu p)
{
    GLdouble mv      [16];
    GLdouble proj    [16];
    GLint    viewport[ 4];
    glGetIntegerv(GL_VIEWPORT        ,  viewport  );
    glGetDoublev (GL_MODELVIEW_MATRIX,  mv        );
    glGetDoublev (GL_PROJECTION_MATRIX, proj      );
    GLdouble x, y, z;
    gluProject(p.x, p.y, p.z, mv, proj, viewport, &x, &y, &z);
    return Vec3_cu( (float)x, (float)y, (float)z);
}

// -----------------------------------------------------------------------------

Vec3_cu un_project(Vec3_cu p)
{
    GLdouble mv      [16];
    GLdouble proj    [16];
    GLint    viewport[ 4];
    glGetIntegerv(GL_VIEWPORT        ,  viewport  );
    glGetDoublev (GL_MODELVIEW_MATRIX,  mv        );
    glGetDoublev (GL_PROJECTION_MATRIX, proj      );
    GLdouble x, y, z;
    gluUnProject(p.x, p.y, p.z, mv, proj, viewport, &x, &y, &z);
    return Vec3_cu( (float)x, (float)y, (float)z);
}


}// End GLU_UTILS ==============================================================



