/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

#ifndef VBO_PRIMITIVES_HPP__
#define VBO_PRIMITIVES_HPP__

#include <deque>
#include "glbuffer_object.hpp"
#include "gen_mesh.hpp"


/** @brief Handle primitive initialization and drawing on GPU
  This class provide various primitive initialization and drawing with opengl
  buffer objects. Some are predifined such as cone cylinder and sphere but
  you can create on GPU the desire primitive with custom tesselation and size
*/

// TODO: should be in the class
typedef int Prim_id;

class VBO_primitives {
public:
    VBO_primitives(){ }
    ~VBO_primitives();

    enum Prim_type {
        TRIANGLE, LINE, LINE_STRIP, QUAD
    };

    //==========================================================================
    /// @name Initialization of custom primitives
    //==========================================================================
    /// @{
    Prim_id init_sphere(float radius, int res);
    Prim_id init_circle(float radius, int res, float diameter = 2.f * M_PI);
    Prim_id init_arc_circle(float radius, int res, float diameter = 2.f * M_PI);
    Prim_id init_grid(float width, float height, int res_x, int res_y);
    Prim_id init_cylinder(float radius, float length, int slices, int res);
    Prim_id init_cylinder_cage(float radius, float length, int caps_res, int body_res);
    Prim_id init_cube();
    /// @}

    Prim_id add_primitive(const Gen_mesh::Tri_Mesh_data& mesh);
    Prim_id add_primitive(const Gen_mesh::Quad_Mesh_data& mesh);
    /// @param strip : wether the mesh composed of a single line strip or lines
    Prim_id add_primitive(const Gen_mesh::Line_data& mesh, bool strip = false);

    //==========================================================================
    /// @name Drawing
    //==========================================================================

    /// Draw a custom primitive
    /// @param id  primitive id returned from a init_xx() method
    void draw(Prim_id id) const;

private:
    //==========================================================================
    /// @name List of opengl buffer objects for custom primitives
    //==========================================================================
    /// @{
    std::deque< GlBuffer_obj* > _vbos; ///< Vertex buffer object
    std::deque< GlBuffer_obj* > _nbos; ///< Normal buffer object
    std::deque< GlBuffer_obj* > _ibos; ///< Index buffer object
    std::deque<int> _nb_elt;
    std::deque<Prim_type> _type;
    /// @}
};

#endif // VBO_PRIMITIVES_HPP__
