/*
 * This software is governed by the CeCILL-B license under French law and
 * abiding by the rules of distribution of free software.  You can  use, 
 * modify and/ or redistribute the software under the terms of the CeCILL-B
 * license as circulated by CEA, CNRS and INRIA at the following URL
 * "http://www.cecill.info" or the LICENCE.txt file present in this project.
*/

/// Portable interface between os and compilers
/// for glew.h header
#ifndef PORT_GLEW_H_
#define PORT_GLEW_H_

#if defined(_WIN32) && defined(_MSC_VER)
    #ifndef NOMINMAX
        #define NOMINMAX // Prevents definition of macro min max in windows.h
    #endif

    #include <windows.h>

    // Undef window.h polluting macros
    #ifdef DIFFERENCE
        #undef DIFFERENCE
    #endif

    #include <GL/glew.h>
#else
    #include <GL/glew.h>
#endif

#endif // PORT_GLEW_H_
