import socket
#HOST = '192.168.1.122' # The remote host

HOST = '127.0.0.1' # the local host
PORT = 54321 # The same port as used by the server
ADDR=(HOST,PORT)

## @brief Execute a MEL command on MAYA
##
## @note Maya must be up and running obviously.
## You also need to run the MEL command by hand on Maya:
## @code
##     commandPort -n ":54321";
## @endcode
## You can make this command execute automatically when maya 
## starts by adding the above line in the file:
## <code> C:\Users\user_name\Documents\maya\version_number\scripts\userSetup.mel</code>
## You may have to create the file yourself.
def send_command(command):
    client = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    client.connect(ADDR)
    client.send(command.encode('utf-8'))    
    #data = client.recv(1024) #receive the result info
    client.close()
    #print('The Result is %s'%data)
   
if __name__=='__main__':
    some_commands = sys.argv[1]    
    send_command(some_commands)
