#include <stdlib.h>
#include <GL/glut.h>

static int _windowNumber;

/* Key events */
void key(unsigned char c, int mouseX, int mouseY)
{
    switch (c)
    {
    /* ESCAPE: leave application */
    case 27 :
        glFinish();
        glutDestroyWindow(_windowNumber);
        exit (0);
        break;
    }
}

/* Rendering function */
void display(void)
{
    /* Window refresh */
    glFlush();
}

int main(int argc, char** argv)
{
    /* GLUT environment initialisation */
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_SINGLE | GLUT_RGB);

    /* Window creation */
    glutInitWindowSize(800, 600);
    glutInitWindowPosition(240, 212);
    _windowNumber = glutCreateWindow(argv[0]);

    /* Keyboard interuptions */
    glutKeyboardFunc(key);

    /* Callback function assignment */
    glutDisplayFunc(display);

    /* Main event loop */
    glutMainLoop();

    return 0;
}
