#include <GL/glut.h>
#include <GL/gl.h>
#include <math.h>

void init_light()
{
    glEnable(GL_LIGHTING);
    glEnable(GL_LIGHT0);
    // Create light components
    GLfloat ambientLight[]  = { 0.2f, 0.2f, 0.2f, 1.0f };
    GLfloat diffuseLight[]  = { 0.8f, 0.8f, 0.8f, 1.0f };
    // Assign created components to GL_LIGHT0
    glLightfv(GL_LIGHT0, GL_AMBIENT,  ambientLight);
    glLightfv(GL_LIGHT0, GL_DIFFUSE,  diffuseLight);
    glEnable(GL_COLOR_MATERIAL);
    glColorMaterial(GL_FRONT, GL_AMBIENT_AND_DIFFUSE);
}

void drawCylindre(float diam, float length)
{
    GLUquadricObj* obj = gluNewQuadric();
    gluCylinder(obj, diam, diam, length, 50, 50);
    gluDeleteQuadric(obj);
}

/* Rendering the window */
void display(void)
{
    glEnable(GL_DEPTH_TEST);
    glClearColor(0.f, 0.f, 0.f, 1.f);
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);

    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
    gluPerspective(40.f, 640.f/480.f, 0.1f, 1000.f);

    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
    gluLookAt(0.f, 5.f,  5.f,
              0.f, 0.f,  0.f,
              0.f, 1.f,  -1.f);

    GLfloat position[] = { 0.f, 0.f, 3.f, 1.0f };
    glLightfv(GL_LIGHT0, GL_POSITION, position);

    // draw something here	


    // -------------------

    glutSwapBuffers();
}

int main (int argc, char** argv)
{
    glutInit(&argc, argv);
    glutInitDisplayMode(GLUT_DOUBLE | GLUT_DEPTH | GLUT_RGB);
    glutInitWindowSize(640, 480);
    glutInitWindowPosition(240, 212);
    glutCreateWindow("My fancy window");
    glutDisplayFunc(display);

    init_light();

    glutMainLoop();
    return (0);
}
