
#include "vector4.h"


void vec4_set (Vec4 v, float a, float b, float c, float d)
{
    v[0]=a;
    v[1]=b;
    v[2]=c;
    v[3]=d;
}

void vec4_copy (Vec4 v, Vec4 res)
{
    int i;
    for (i=0; i<4; i++) res[i] = v[i];
}

void vec4_cross_product (Vec4 v1, Vec4 v2, Vec4 res)
{
    res[0] = v1[1]*v2[2] - v1[2]*v2[1];
    res[1] = v1[2]*v2[0] - v1[0]*v2[2];
    res[2] = v1[0]*v2[1] - v1[1]*v2[0];
    res[3] = 0.;
}

void vec4_normalize (Vec4 v)
{
    float norm = sqrt(v[0]*v[0] + v[1]*v[1] + v[2]*v[2]);
    if(norm > 0.0001f)
    {
        v[0] /= norm;
        v[1] /= norm;
        v[2] /= norm;
    }
}

void vec4_sum (Vec4 v1, Vec4 v2, Vec4 res)
{
    res[0] = v1[0]+v2[0];
    res[1] = v1[1]+v2[1];
    res[2] = v1[2]+v2[2];
    res[3] = v1[3];
}

void vec4_diff (Vec4 v1, Vec4 v2, Vec4 res)
{
    res[0] = v1[0]-v2[0];
    res[1] = v1[1]-v2[1];
    res[2] = v1[2]-v2[2];
    res[3] = 0.;
}

void vec4_mult_scalar (float f, Vec4 v, Vec4 res)
{
    res[0] = f*v[0];
    res[1] = f*v[1];
    res[2] = f*v[2];
    res[3] = v[3];
}
